(defun c:lpinb()
(setq F (getvar "blipmode")) (setvar "blipmode" 0)
(setq p (getpoint "Insert point:"))
(setq D (getint "\n Enter diameter [16] [20] [25] [30] [35] [40] [50] [60]:"))
(setq L (getint "Enter cavity plate thickness:"))
(setq L1 (getint "Enter core plate thickness:"))
(setq A (getreal "Enter lpinb angle:"))
(setq B (* pi (/ A 180)))
(setq p34 (polar p (+ B (/ pi 2)) (- (* 0.5 D) 1.5)))
(setq p35 (polar p (- B (/ pi 2)) (- (* 0.5 D) 1.5)))
(command "break" p34 p35 "")
(if (= D 16)
 (progn
  (setq D1 30)
  (setq D2 25)
  (setq H 6)
  (setq M 8)))
(if (= D 20)
 (progn
  (setq D1 35)
  (setq D2 30)
  (setq H 8)
  (setq M 10)))
(if (= D 25)
 (progn
  (setq D1 40)
  (setq D2 35)
  (setq H 8)
  (setq M 12)))
(if (= D 30)
 (progn
  (setq D1 47)
  (setq D2 42)
  (setq H 10)
  (setq M 15)))
(if (= D 35)
 (progn
  (setq D1 54)
  (setq D2 48)
  (setq H 10)
  (setq M 15)))
(if (= D 40)
 (progn
  (setq D1 61)
  (setq D2 55)
  (setq H 12)
  (setq M 20)))
(if (= D 50)
 (progn
  (setq D1 76)
  (setq D2 70)
  (setq H 15)
  (setq M 25)))
(if (= D 60)
 (progn
  (setq D1 86)
  (setq D2 80)
  (setq H 15)
  (setq M 25)))
(setq p1 (polar p (+ B pi) (- L1 H)))
(setq p2 (polar p1 B 4))
(setq p3 (polar p2 (+ B (/ pi 2)) (- (/ D2 2.0) 0.5)))
(setq p4 (polar p2 (- B (/ pi 2)) (- (/ D2 2.0) 0.5)))
(setq p5 (polar p2 (+ B (/ pi 2)) (/ D2 2.0)))
(setq p6 (polar p2 (- B (/ pi 2)) (/ D2 2.0)))
(setq p9 (polar p1 (+ B (/ pi 2)) (/ D1 2)))
(setq p10 (polar p1 (- B (/ pi 2)) (/ D1 2)))
(setq p11 (polar p9 (+ B pi) H))
(setq p12 (polar p10 (+ B pi) H))
(setq p7 (polar p (+ B (/ pi 2)) (/ D2 2.0)))
(setq p8 (polar p (- B (/ pi 2)) (/ D2 2.0)))
(setq p13 (polar p1 (+ B (/ pi 2)) (- (/ D2 2.0) 0.5)))
(setq p14 (polar p1 (- B (/ pi 2)) (- (/ D2 2.0) 0.5)))
(setq p29 (polar p (+ B pi) 1.5))
(setq p30 (polar p29 (+ B (/ pi 2)) (/ D2 2.0)))
(setq p31 (polar p29 (- B (/ pi 2)) (/ D2 2.0)))
(setq p32 (polar p29 (+ B (/ pi 2)) (/ D 2.0)))
(setq p33 (polar p29 (- B (/ pi 2)) (/ D 2.0)))
(setq p34 (polar p32 B 3.0))
(setq p35 (polar p33 B 3.0))
(command "line" p11 p12 p10 p9 "c")
(command "line" p7 p5 p6 p8 "")
(command "line" p3 p13 "")
(command "line" p4 p14 "")
(command "line" p30 p31 "")
(command "arc" p32 "E" p34 "A" 180)
(command "line" p34 p35 "")
(command "arc" p35 "E" p33 "A" 180)
(setq p15 (polar p B (- L 2)))
(setq p16 (polar p B (- L (+ 2 M))))
(setq p28 (polar p16 B 1.5))
(setq p24 (polar p16 (- B (/ pi 2)) (/ D 2.0)))
(setq p25 (polar p16 (+ B (/ pi 2)) (/ D 2.0)))
(setq p27 (polar p24 (+ B 0.087266) (/ M (cos 0.087266))))
(setq p26 (polar p25 (- B 0.087266) (/ M (cos 0.087266))))
(if (>= (- L (+ 3 M)) D)
(progn
(setq N (/ (- L (+ 3 M)) D))
(setq X 1)
(Repeat N
(setq p17 (polar p28 (+ B pi) (* X D)))
(setq p18 (polar p17 (+ B (/ pi 2)) (/ D 2.0)))
(setq p19 (polar p17 (- B (/ pi 2)) (/ D 2.0)))
(setq p20 (polar p19 B 1.5))
(setq p21 (polar p18 B 1.5))
(setq p22 (polar p19 B -1.5))
(setq p23 (polar p18 B -1.5))
(command "line" p21 (polar p21 B (- D 3.0))
(polar p20 B (- D 3.0)) p20 "")
(command "arc" p23 "E" p21 "A" 180)
(command "line" p21 p20 "")
(command "arc" p20 "E" p22 "A" 180)
(setq X (+ 1 X)))
(command "line" p34 p23 p22 p35 ""))
(command "line" p34 p25 p24 p35 ""))
(command "pline" p24 "W" 0 0 p27 p26 p25 "")
(command "fillet" "R" 3.0 "fillet" "P" "L")
(setvar "blipmode" F))
